/****** Object:  View [dbo].[V_VENDAS_x_COMPRAS]    Script Date: 02/14/2014 19:12:46 ******/
IF EXISTS( SELECT * FROM sys.views
			WHERE  object_id = OBJECT_ID(N'[dbo].[V_VENDAS_x_COMPRAS]'))
	DROP VIEW [dbo].[V_VENDAS_x_COMPRAS];
GO
GO
GO
GO
--SELECT TIPO_TRANSACAO FROM V_VENDAS_x_COMPRAS where DT_VD between '2010-12-01' and '2010-12-10' and ds_mov_op LIKE '%PEDIDO DE COMPRAS%'
--versao 2695

CREATE VIEW [dbo].[V_VENDAS_x_COMPRAS]
AS
	 SELECT
			PDV_VD_IT.CD_EMP
		  , PDV_VD_IT.CD_FILIAL
		  , PDV_VD_IT.DT_VD
		  , PDV_VD.DT_VD AS DT_ENTRADA
		  , PDV_VD_IT.CD_PROD
		  , PDV_VD_IT.QT_IT AS QT_VD
		  , (PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT) AS VLR_VD
		  , 0 AS QT_CP
		  , 0 AS VLR_CP_IMPOSTO
		  , 0 AS VLR_CP_SEM_IMPOSTO
		  , 0 AS VLR_CP_BRUTO
		  , 0 AS VLR_DESC_CP
		  , 0 AS QT_OUTRAS_ENT
		  , 0 AS VLR_OUTRAS_ENT
		  , 0 AS QT_OUTRAS_SAI
		  , 0 AS VLR_OUTRAS_SAI
		  , CASE
				WHEN PDV_VD_IT.TP_PROD IN(10, 11) THEN(PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT) - ((PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT) * (PDV_VD_IT.PERC_COMISSAO_SERVICO / 100))
				ELSE(PDV_VD_IT.QT_IT * PDV_VD_IT.VLR_CUSTO)
			END AS VLR_VD_CUSTO
		  , CASE
				WHEN PDV_VD_IT.TP_PROD IN(10, 11) THEN(PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT) - ((PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT) * (PDV_VD_IT.PERC_COMISSAO_SERVICO / 100))
				ELSE(PDV_VD_IT.QT_IT * PDV_VD_IT.VLR_CUSTO_MEDIO)
			END AS VLR_VD_CUSTO_MD
		  , (PDV_VD_IT.QT_IT * VLR_PMC) AS VLR_VD_PMC
		  , PDV_VD_IT.CD_TRIB_FC
		  , 'VENDAS' AS DS_MOV_OP
		  , 0 AS QT_IT_PED_CP
		  , 0 AS VLR_IT_PED_CP
		  , 0 AS PERC_DESC_FINAN
		  , 0 AS VLR_DESC_FINAN_PROD
		  , 0 AS VLR_DESC_FINAN_PROD_UNIT
		  , CASE
				WHEN PDV_VD_IT.TP_PROD IN(10, 11) THEN(PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT) - ((PDV_VD_IT.TOT_IT - PDV_VD_IT.VLR_DESC_TOT_RAT) * (PDV_VD_IT.PERC_COMISSAO_SERVICO / 100))
				ELSE(PDV_VD_IT.QT_IT * ISNULL(PDV_VD_IT.VLR_CUSTO_GER, 0))
			END AS VLR_CUSTO_GER
		  , 'SAIDA' AS TIPO_TRANSACAO
	 FROM
		 PDV_VD_IT
		 INNER JOIN PDV_VD ON PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP
							  AND PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL
							  AND PDV_VD_IT.CD_VD = PDV_VD.CD_VD
							  AND PDV_VD_IT.DT_VD = PDV_VD_IT.DT_VD 
	 WHERE    (PDV_VD.ST_VD = 0)
			  AND (PDV_VD_IT.CD_EMP = 1)
			  AND (PDV_VD_IT.ST_IT = 1)
	 UNION ALL
	 SELECT
			PDV_VD_DEV_EST_PROD_IMP.CD_EMP
		  , PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL
		  , PDV_VD_DEV_EST_PROD_IMP.DT_DEVO
		  , PDV_VD_DEV_EST_PROD_IMP.DT_DEVO
		  , PDV_VD_DEV_EST_PROD_IMP.CD_PROD
		  , PDV_VD_DEV_EST_PROD_IMP.QT_IT * -1 AS QT_VD
		  , ((PDV_VD_DEV_EST_PROD_IMP.VLR_IT * PDV_VD_DEV_EST_PROD_IMP.QT_IT) * -1) AS VLR_VD
		  , 0 AS QT_CP
		  , 0 AS VLR_CP_IMPOSTO
		  , 0 AS VLR_CP_SEM_IMPOSTO
		  , 0 AS VLR_CP_BRUTO
		  , 0 AS VLR_DESC_CP
		  , 0 AS QT_OUTRAS_ENT
		  , 0 AS VLR_OUTRAS_ENT
		  , 0 AS QT_OUTRAS_SAI
		  , 0 AS VLR_OUTRAS_SAI
		  , ((PDV_VD_DEV_EST_PROD_IMP.QT_IT * EST_PROD_CPL.VLR_CUSTO) * -1) AS VLR_VD_CUSTO
		  , ((PDV_VD_DEV_EST_PROD_IMP.QT_IT * EST_PROD_CPL.VLR_CUSTO_MD) * -1) AS VLR_VD_CUSTO_MD
		  , ((PDV_VD_DEV_EST_PROD_IMP.QT_IT * PDV_VD_DEV_EST_PROD_IMP.VLR_PMC_IT) * -1) AS VLR_VD_PMC
		  , PDV_VD_IT.CD_TRIB_FC
		  , 'DEVOLUCAO' AS DS_MOV_OP
		  , 0 AS QT_IT_PED_CP
		  , 0 AS VLR_IT_PED_CP
		  , 0 AS PERC_DESC_FINAN
		  , 0 AS VLR_DESC_FINAN_PROD
		  , 0 AS VLR_DESC_FINAN_PROD_UNIT
		  , 0 AS VLR_CUSTO_GER
		  , 'ENTRADA' AS TIPO_TRANSACAO
	 FROM
		 PDV_VD_DEV_EST_PROD_IMP
		 INNER JOIN EST_PROD_CPL ON PDV_VD_DEV_EST_PROD_IMP.CD_EMP = EST_PROD_CPL.CD_EMP
									AND PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
									AND PDV_VD_DEV_EST_PROD_IMP.CD_PROD = EST_PROD_CPL.CD_PROD
		 INNER JOIN PDV_VD_IT ON PDV_VD_IT.CD_EMP = PDV_VD_DEV_EST_PROD_IMP.CD_EMP
								 AND PDV_VD_IT.CD_FILIAL = PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL
								 AND PDV_VD_IT.CD_VD = PDV_VD_DEV_EST_PROD_IMP.CD_VD
								 AND PDV_VD_IT.CD_PROD = PDV_VD_DEV_EST_PROD_IMP.CD_PROD
								 AND PDV_VD_IT.CD_IT = PDV_VD_DEV_EST_PROD_IMP.CD_IT
	 UNION ALL
	 SELECT
			CD_EMP
		  , CD_FILIAL
		  , DT_EMI_NF
		  , DT_EMI_NF
		  , CD_PROD
		  , 0 AS QT_VD
		  , 0 AS VLR_VD
		  , 0 AS QT_CP
		  , 0 AS VLR_CP_IMPOSTO
		  , 0 AS VLR_CP_SEM_IMPOSTO
		  , 0 AS VLR_CP_BRUTO
		  , 0 AS VLR_DESC_CP
		  , 0 AS QT_OUTRAS_ENT
		  , 0 AS VLR_OUTRAS_ENT
		  , QT_IT AS QT_OUTRAS_SAI
		  , VLR_TOT_IT AS VLR_OUTRAS_SAI
		  , 0 AS VLR_VD_CUSTO
		  , 0 AS VLR_VD_CUSTO_MD
		  , 0 AS VLR_VD_PMC
		  , CD_TRIB_FC
		  , DS_MOV_OP
		  , 0 AS QT_IT_PED_CP
		  , 0 AS VLR_IT_PED_CP
		  , 0 AS PERC_DESC_FINAN
		  , 0 AS VLR_DESC_FINAN_PROD
		  , 0 AS VLR_DESC_FINAN_PROD_UNIT
		  , 0 AS VLR_CUSTO_GER
		  , 'SAIDA' AS TRANSACAO
	 FROM
		 V_EST_NF_SAI
	 WHERE   V_EST_NF_SAI.TP_MOV <> 28
	 UNION ALL
	 SELECT
			EST_PROD_REQ_TRANSF_LIB.CD_EMP
		  , EST_PROD_REQ_TRANSF_LIB.CD_FILIAL
		  , EST_PROD_REQ_TRANSF_LIB.DT_CAD
		  , EST_PROD_REQ_TRANSF_LIB.DT_CAD
		  , EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD
		  , 0
		  , 0
		  , 0
		  , 0 AS VLR_CP_IMPOSTO
		  , 0 AS VLR_CP_SEM_IMPOSTO
		  , 0 AS VLR_CP_BRUTO
		  , 0 AS VLR_DESC_CP
		  , 0
		  , 0
		  , EST_PROD_REQ_TRANSF_LIB_ITENS.QT_PROD
		  , EST_PROD_REQ_TRANSF_LIB_ITENS.QT_PROD * EST_PROD_CPL.VLR_CUSTO
		  , 0
		  , 0
		  , 0
		  , '060' AS CD_TRIB_FC
		  , 'REQUISICAO SAIDA' AS DS_MOV_OP
		  , 0 AS QT_IT_PED_CP
		  , 0 AS VLR_IT_PED_CP
		  , 0 AS PERC_DESC_FINAN
		  , 0 AS VLR_DESC_FINAN_PROD
		  , 0 AS VLR_DESC_FINAN_PROD_UNIT
		  , 0 AS VLR_CUSTO_GER
		  , 'SAIDA' TIPO_TRANSACAO
	 FROM
		 EST_PROD_REQ_TRANSF_LIB
		 INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS ON EST_PROD_REQ_TRANSF_LIB.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP
													 AND EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL
													 AND EST_PROD_REQ_TRANSF_LIB.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ
		 INNER JOIN EST_PROD_CPL ON EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP = EST_PROD_CPL.CD_EMP
									AND EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
									AND EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD = EST_PROD_CPL.CD_PROD
		 INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP ON EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_EMP
																  AND EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_FILIAL
																  AND EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_REQ
																  AND EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD = EST_PROD_REQ_TRANSF_LIB_ITENS_EST_PROD_IMP.CD_PROD
	 UNION ALL
	 SELECT
			V_EST_NF_ENT.CD_EMP
		  , V_EST_NF_ENT.CD_FILIAL
		  , V_EST_NF_ENT.DT_EMI_NF
		  , V_EST_NF_ENT.DT_ENT AS DT_ENTRADA
		  , V_EST_NF_ENT.CD_PROD
		  , 0 AS QT_VD
		  , 0 AS VLR_VD
		  , CASE
				WHEN TP_MOV = 0 THEN V_EST_NF_ENT.QT_IT
				ELSE 0
			END AS QT_CP
		  , CASE WHEN V_EST_NF_ENT.TP_MOV = 0 THEN 
				CASE WHEN V_EST_NF_ENT.VLR_OUTROS = 0 THEN 
				    CASE WHEN V_EST_NF_ENT.VLR_FRETE = 0 THEN
					   (((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT)) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT
				    ELSE
					   (((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT)) + V_EST_NF_ENT.VLR_IPI_IT 
						  + V_EST_NF_ENT.VLR_ICMS_SUBS_IT 
						  + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_FRETE)), 9) 
						  * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT))
				    END
				ELSE 
				    CASE WHEN CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS) > 0 THEN 
					   CASE WHEN V_EST_NF_ENT.VLR_FRETE = 0 THEN
						  (((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT)) 
							 + V_EST_NF_ENT.VLR_IPI_IT 
							 + V_EST_NF_ENT.VLR_ICMS_SUBS_IT 
							 + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_OUTROS) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS)), 9) 
							 * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT))
					   ELSE
						  (((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT)) 
							 + V_EST_NF_ENT.VLR_IPI_IT 
							 + V_EST_NF_ENT.VLR_ICMS_SUBS_IT 
							 + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_OUTROS) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS)), 9) 
							 * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT)) 
							 + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_FRETE)), 9) 
							 * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT))
					   END
				    ELSE 0
				    END 
				END
			ELSE 0
			END AS VLR_CP_IMPOSTO

		  , CASE
				WHEN TP_MOV = 0 THEN V_EST_NF_ENT.VLR_TOT_IT
				ELSE 0
			END AS VLR_CP_SEM_IMPOSTO
		  , CASE
				WHEN V_EST_NF_ENT.TP_MOV = 0 THEN(V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT)
				ELSE 0
			END AS VLR_CP_BRUTO
		  , CASE
				WHEN V_EST_NF_ENT.TP_MOV = 0 THEN V_EST_NF_ENT.VLR_DESC_IT
				ELSE 0
			END AS VLR_DESC_CP
		  , CASE
				WHEN TP_MOV <> 0 THEN V_EST_NF_ENT.QT_IT
				ELSE 0
			END AS QT_OUTRAS_ENT
		  , CASE
				WHEN V_EST_NF_ENT.TP_MOV <> 0 THEN VLR_TOT_IT + VLR_ICMS_SUBS + VLR_IPI
				ELSE 0
			END AS VLR_OUTRAS_ENT
		  , 0 AS QT_OUTRAS_SAI
		  , 0 AS VLR_OUTRAS_SAI
		  , 0 AS VLR_VD_CUSTO
		  , 0 AS VLR_VD_CUSTO_MD
		  , 0 AS VLR_VD_PMC
		  , CD_TRIB_FC
		  , DS_MOV_OP
		  , 0 AS QT_IT_PED_CP
		  , 0 AS VLR_IT_PED_CP
		  , PERC_DESC_FINAN
		  , VLR_DESC_FINAN_PROD
		  , VLR_DESC_FINAN_PROD_UNIT
		  , 0 AS VLR_CUSTO_GER
		  , 'ENTRADA' AS TIPO_TRANSACAO
	 FROM
		 (SELECT
		    DBO.EST_NF_ENT_IT.CD_EMP
		  , DBO.EST_NF_ENT_IT.CD_FILIAL
		  , DBO.EST_NF_ENT_IT.CD_NF		 
		  , DBO.EST_NF_ENT_IT.DT_ENT
		  , DBO.EST_NF_ENT.DT_EMI_NF
		  , DBO.EST_NF_ENT.VLR_NF
		  , DBO.EST_NF_ENT.VLR_ICMS_SUBS
		  , DBO.EST_NF_ENT.VLR_FRETE
		  , DBO.EST_NF_ENT.VLR_IPI
		  , DBO.EST_NF_ENT.VLR_OUTROS
		  
		  
		  , DBO.EST_NF_ENT_IT.CD_PROD 
		  , DBO.EST_TRIB.CD_TRIB_FC
		  , ISNULL(DBO.EST_TRIB.TRIB_FC_ELETRONICO, '') TRIB_FC_ELETRONICO
		  , DBO.EST_NF_ENT_IT.QT_IT
		  , CONVERT(FLOAT, EST_NF_ENT_IT.VLR_TOT_IT) / CONVERT(FLOAT,
															   CASE
																   WHEN EST_NF_ENT_IT.QT_IT = 0 THEN 1
																   ELSE EST_NF_ENT_IT.QT_IT
															   END) AS VLR_IT
		  , CASE
				WHEN ISNULL(DBO.EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0 THEN DBO.EST_NF_ENT_IT.VLR_TOT_IT
				ELSE DBO.EST_NF_ENT_IT.VLR_TOT_IT - EST_NF_ENT_IT.VLR_DESC
			END AS VLR_TOT_IT
		  , DBO.EST_NF_ENT_IT.ALIQ_ICMS
		  , DBO.EST_NF_ENT_IT.VLR_IPI AS VLR_IPI_IT
		  , DBO.EST_NF_ENT_IT.VLR_ICMS_SUBS AS VLR_ICMS_SUBS_IT
		  , DBO.EST_NF_ENT_IT.VLR_DESC AS VLR_DESC_IT
		  , DBO.GLB_MOV_OP.DS_MOV_OP 
		  , DBO.GLB_MOV_OP.TP_MOV		  
		  , ISNULL(EST_NF_ENT_IT.PERC_DESC_FINAN, 0) AS PERC_DESC_FINAN
		  , ROUND(ISNULL((CASE
							  WHEN ISNULL(DBO.EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0 THEN(EST_NF_ENT_IT.VLR_TOT_IT + EST_NF_ENT_IT.VLR_FRETE_IT)
							  ELSE(EST_NF_ENT_IT.VLR_TOT_IT + EST_NF_ENT_IT.VLR_ICMS_SUBS + EST_NF_ENT_IT.VLR_IPI + EST_NF_ENT_IT.VLR_FRETE_IT) - EST_NF_ENT_IT.VLR_DESC
						  END) * (EST_NF_ENT_IT.PERC_DESC_FINAN / 100), 0), 2) AS VLR_DESC_FINAN_PROD
		  , ROUND(ISNULL((CASE
							  WHEN ISNULL(DBO.EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0 THEN(EST_NF_ENT_IT.VLR_TOT_IT + EST_NF_ENT_IT.VLR_ICMS_SUBS + EST_NF_ENT_IT.VLR_IPI + EST_NF_ENT_IT.VLR_FRETE_IT)
							  ELSE(EST_NF_ENT_IT.VLR_TOT_IT + EST_NF_ENT_IT.VLR_ICMS_SUBS + EST_NF_ENT_IT.VLR_IPI + EST_NF_ENT_IT.VLR_FRETE_IT) - EST_NF_ENT_IT.VLR_DESC
						  END) * (EST_NF_ENT_IT.PERC_DESC_FINAN / 100), 0) / CASE
																				 WHEN EST_NF_ENT_IT.QT_IT = 0 THEN 1
																				 ELSE EST_NF_ENT_IT.QT_IT
																			 END, 2) AS VLR_DESC_FINAN_PROD_UNIT  
	 FROM
		 DBO.EST_NF_ENT
		 INNER JOIN PRC_FILIAL FL ON DBO.EST_NF_ENT.CD_EMP = FL.CD_EMP
									 AND DBO.EST_NF_ENT.CD_FILIAL = FL.CD_FILIAL
		 INNER JOIN DBO.EST_NF_ENT_IT ON DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
										 AND DBO.EST_NF_ENT.CD_FILIAL = DBO.EST_NF_ENT_IT.CD_FILIAL
										 AND DBO.EST_NF_ENT.CD_NF = DBO.EST_NF_ENT_IT.CD_NF
										 AND DBO.EST_NF_ENT.DT_ENT = DBO.EST_NF_ENT_IT.DT_ENT
		 INNER JOIN DBO.EST_PROD ON DBO.EST_PROD.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
								AND DBO.EST_PROD.CD_PROD = DBO.EST_NF_ENT_IT.CD_PROD
		 INNER JOIN DBO.GLB_MOV_OP ON DBO.EST_NF_ENT.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP 
		 INNER JOIN DBO.EST_TRIB ON DBO.EST_NF_ENT_IT.CD_TRIB = DBO.EST_TRIB.CD_TRIB
		 INNER JOIN DBO.EST_NF_SERIE ON DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_SERIE.CD_EMP
										AND DBO.EST_NF_ENT.CD_NF_SERIE = DBO.EST_NF_SERIE.CD_NF_SERIE 
		
		 
		 )    V_EST_NF_ENT
		 LEFT OUTER JOIN PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT ON V_EST_NF_ENT.CD_EMP = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_EMP
															   AND V_EST_NF_ENT.CD_FILIAL = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_FILIAL
															   AND V_EST_NF_ENT.CD_NF = PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_NF
	 WHERE   PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT.CD_NF IS NULL
	  
	 UNION ALL
	 SELECT
			EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_EMP
		  , EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_FILIAL_DEST
		  , EST_PROD_IMP.DT_CAD
		  , EST_PROD_IMP.DT_CAD
		  , EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD
		  , 0
		  , 0
		  , 0
		  , 0 AS VLR_CP_IMPOSTO
		  , 0 AS VLR_CP_SEM_IMPOSTO
		  , 0 AS VLR_CP_BRUTO
		  , 0 AS VLR_DESC_CP
		  , EST_PROD_REQ_TRANSF_LIB_ITENS.QT_PROD
		  , EST_PROD_REQ_TRANSF_LIB_ITENS.QT_PROD * EST_PROD_CPL.VLR_CUSTO
		  , 0
		  , 0
		  , 0
		  , 0
		  , 0
		  , '060' AS CD_TRIB_FC
		  , 'REQUISICAO ENTRADA' AS DS_MOV_OP
		  , 0 AS QT_IT_PED_CP
		  , 0 AS VLR_IT_PED_CP
		  , 0 AS PERC_DESC_FINAN
		  , 0 AS VLR_DESC_FINAN_PROD
		  , 0 AS VLR_DESC_FINAN_PROD_UNIT
		  , 0 AS VLR_CUSTO_GER
		  , 'ENTRADA' AS TIPO_TRANSACAO
	 FROM
		 EST_PROD_REQ_TRANSF_LIB
		 INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS ON EST_PROD_REQ_TRANSF_LIB.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP
													 AND EST_PROD_REQ_TRANSF_LIB.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL
													 AND EST_PROD_REQ_TRANSF_LIB.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ
		 INNER JOIN EST_PROD_CPL ON EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP = EST_PROD_CPL.CD_EMP
									AND EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
									AND EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD = EST_PROD_CPL.CD_PROD
		 INNER JOIN EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP ON EST_PROD_REQ_TRANSF_LIB_ITENS.CD_EMP = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_EMP
																	  AND EST_PROD_REQ_TRANSF_LIB_ITENS.CD_FILIAL = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_FILIAL_ORIG
																	  AND EST_PROD_REQ_TRANSF_LIB_ITENS.CD_REQ = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_REQ
																	  AND EST_PROD_REQ_TRANSF_LIB_ITENS.CD_PROD = EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_PROD
		 INNER JOIN EST_PROD_IMP ON EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_EMP = EST_PROD_IMP.CD_EMP
									AND EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_FILIAL_DEST = EST_PROD_IMP.CD_FILIAL
									AND EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_IMP = EST_PROD_IMP.CD_IMP
									AND EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP.CD_PROD = EST_PROD_IMP.CD_PROD
	 UNION ALL
	 SELECT
			EST_PED_CP.CD_EMP
		  , EST_PED_CP.CD_FILIAL
		  , EST_PED_CP.DT_EMI
		  , EST_PED_CP.DT_EMI
		  , EST_PED_CP_IT.CD_PROD
		  , 0 AS QT_VD
		  , 0 AS VLR_VD
		  , 0 AS QT_CP
		  , 0 AS VLR_CP_IMPOSTO
		  , 0 AS VLR_CP_SEM_IMPOSTO
		  , 0 AS VLR_CP_BRUTO
		  , 0 AS VLR_DESC_CP
		  , 0 AS QT_OUTRAS_ENT
		  , 0 AS VLR_OUTRAS_ENT
		  , 0 AS QT_OUTRAS_SAI
		  , 0 AS VLR_OUTRAS_SAI
		  , 0 AS VLR_VD_CUSTO
		  , 0 AS VLR_VD_CUSTO_MD
		  , 0 AS VLR_VD_PMC    
    --EST_TRIB.CD_TRIB_FC,
		  , '000' CD_TRIB_FC
		  , 'PEDIDO DE COMPRAS'
		  , EST_PED_CP_IT.QT_IT AS QT_IT_PED_CP
		  , (EST_PED_CP_IT.QT_IT * EST_PED_CP_IT.VLR_IT) AS VLR_IT_PED_CP
		  , 0 AS PERC_DESC_FINAN
		  , 0 AS VLR_DESC_FINAN_PROD
		  , 0 AS VLR_DESC_FINAN_PROD_UNIT
		  , 0 AS VLR_CUSTO_GER
		  , 'PEDIDO DE COMPRAS' AS TIPO_TRANSACAO
	 FROM
		 EST_PED_CP
		 INNER JOIN EST_PED_CP_IT ON EST_PED_CP.CD_EMP = EST_PED_CP_IT.CD_EMP
									 AND EST_PED_CP.CD_FILIAL = EST_PED_CP_IT.CD_FILIAL
									 AND EST_PED_CP.CD_PED = EST_PED_CP_IT.CD_PED; 
  
